<?php

/**
 * REST backend for JavaScript code (AJAX calls).
 */
//

function checkSession() {

    startSession();

    global $session;
    if ($session->getUser() === null) {
        http_response_code(401);
        die("You must be registered to perform this action");
    }
}

Flight::route('POST /join', function() {

    checkSession();
    global $session, $dao, $mailSender;

    $selectedUserIndex = Flight::request()->data['selectedUserIndex'];
    $selectedSearchResult = $session->userSearchResults[$selectedUserIndex];
    $targetUserId = $selectedSearchResult->getUser()->id;

    $token = RAP\Util::createNewToken();
    $dao->createJoinRequest($token, $session->user->id, $targetUserId);
    $mailSender->sendJoinEmail($selectedSearchResult->getUser(), $session->user, $token);

    echo $selectedSearchResult->userDisplayText;
});

/**
 * Set the primary identity based on the index of the identity clicked by the
 * user on the Account Management page. We MUST use the index and not directly
 * the identity id for security reason (one can use the browser developer tools
 * for calling the AJAX call with an arbitrary number).
 */
Flight::route('POST /primary-identity', function() {

    checkSession();
    global $session, $dao;

    $identityIndex = intval(Flight::request()->data['index']);
    $identityId = $session->user->identities[$identityIndex]->id;

    $dao->setPrimaryIdentity($session->user->id, $identityId);
    $session->updatePrimaryIdentity($identityId);

    // Following variable is used to render user-data
    $user = $session->getUser();
    include 'user-data.php';
});
