# RAP IA2

## Installation and configuration

Requirements:

* Apache httpd server (tested on Apache/2.4.6)
* PHP (5.4+), composer for dependecies
* MySQL/MariaDB (tested on MariaDB 5.5.52)
* PHP MySQL module

On Ubuntu:

    sudo apt install apache2 mariadb-server libapache2-mod-php mariadb-server php7.2-xml php7.2-mbstring php-mysql php-curl

### PHP

Put RAP sources in `/var/www/html/rap-ia2`

For installing PHP dependencies run:

    composer install

Install also the bcmath PHP package (used in X.509 parser).

### MySQL / MariaDB

Create a dedicated database and user:

    CREATE DATABASE rap;
    CREATE USER rap@localhost IDENTIFIED BY 'XXXXXX';
    GRANT ALL PRIVILEGES ON rap.* TO rap@localhost;

Enable the event scheduler:

* open MySQL configuration file (e.g. /etc/my.cnf, or /etc/mysql/mariadb.conf.d/*-server.cnf for MariaDB)
* under the section [mysqld] set `event_scheduler=1`
* restart MySQL

Then run the setup script:

    mysql -u root -p <  sql/setup-database.sql

### Apache (httpd)

* Enable .htaccess in rap folder:

In Apache configuration (e.g. /etc/apache2/apache2.conf) add:

    <Directory /var/www/html/rap-ia2/>
        AllowOverride All
    </Directory>

* Enable Apache mod rewrite: `sudo a2enmod rewrite`
* Configure a valid HTTPS certificate on the server
* Configure X.509 client certificate authentication:

        <Directory /var/www/html/rap-ia2/auth/x509/>
            Options Indexes FollowSymLinks
            AllowOverride None
            Order allow,deny
            allow from all
            SSLVerifyClient require
            SSLVerifyDepth 10
            SSLOptions +ExportCertData
        </Directory>

* Shibboleth authentication:

        <Directory /var/www/html/rap-ia2/auth/saml2/>
            AuthType shibboleth
            ShibRequestSetting requireSession 1
            Require valid-user
        </Directory>

* Protect log directory:

        <Directory /var/www/html/rap-ia2/logs/>
            Order deny,allow
            Deny From All
        </Directory>

* Protect RAP Web Service in Basic-Auth:

        <Location "/rap-ia2/ws">
            AuthType basic
            AuthName RAP
            AuthUserFile apachepasswd
            Require valid-user
        </Location>

* Then creates a password file for RAP Web Service Basic-Auth:
    * `cd /etc/httpd/`
    * `htpasswd -c apachepasswd rap`
        * The last command creates an hashed password for an user "rap" and store it in a file named apachepasswd.

* Finally, restart the Apache server.

### Social networks

Before using social API it is necessary to register an application on each social network and obtain API keys and secrets:

* https://console.developers.google.com
* https://www.linkedin.com/developer/apps
* https://developers.facebook.com/apps

### Configuration file

Copy the `config-example.php` into `config.php` and edit it for matching your needs.

### Logs directory

Create the logs directory and assign ownership to the Apache user (usually www-data or apache)

    mkdir logs
    sudo chown www-data logs

### Run Unit Tests and build code coverage report

(XDebug or another code coverage driver needs to be installed; e.g. `sudo apt install php-xdebug`)

    ./vendor/bin/phpunit --bootstrap vendor/autoload.php --coverage-html build/coverage-report tests/

## Additional information and developer guide

See the wiki: https://www.ict.inaf.it/gitlab/zorba/rap-ia2/wikis/home
