<?php

namespace RAP;

class MySQLRefreshTokenDAO extends BaseMySQLDAO implements RefreshTokenDAO {

    public function __construct(Locator $locator) {
        parent::__construct($locator);
    }

    function createRefreshToken(RefreshToken $refreshToken): RefreshToken {

        $dbh = $this->getDBHandler();
        $stmt = $dbh->prepare("INSERT INTO refresh_token (token, user_id, client_id, scope, creation_time, expiration_time)"
                . " VALUES(:token, :user_id, :client_id, :scope, :creation_time, :expiration_time)");

        $scope = null;
        if ($refreshToken->scope !== null) {
            $scope = join(' ', $refreshToken->scope);
        }

        $params = array(
            ':token' => $refreshToken->token,
            ':user_id' => $refreshToken->userId,
            ':client_id' => $refreshToken->clientId,
            ':scope' => $scope,
            ':creation_time' => $refreshToken->creationTime,
            ':expiration_time' => $refreshToken->expirationTime
        );

        if ($stmt->execute($params)) {
            return $refreshToken;
        } else {
            error_log($stmt->errorInfo()[2]);
            throw new \Exception("SQL error while storing user token");
        }
    }

    function getRefreshToken(string $tokenValue): ?RefreshToken {

        $dbh = $this->getDBHandler();

        $stmt = $dbh->prepare("SELECT token, user_id, client_id, creation_time, expiration_time, scope "
                . " FROM refresh_token WHERE token = :token");

        $stmt->bindParam(':token', $tokenValue);

        $stmt->execute();

        $row = $stmt->fetch();
        if (!$row) {
            return null;
        }

        $token = new RefreshToken();
        $token->token = $row['token'];
        $token->userId = $row['user_id'];
        $token->clientId = $row['client_id'];
        $token->creationTime = $row['creation_time'];
        $token->expirationTime = $row['expiration_time'];

        $scope = null;
        if (isset($row['scope'])) {
            $scope = $row['scope'];
        }
        if ($scope !== null && $scope !== '') {
            $token->scope = explode(' ', $scope);
        }

        return $token;
    }

    function deleteRefreshToken(string $token): void {

        $dbh = $this->getDBHandler();

        $stmt = $dbh->prepare("DELETE FROM refresh_token WHERE token = :token");
        $stmt->bindParam(':token', $token);
        $stmt->execute();
    }

}
