<?php

namespace RAP;

class FacebookLogin extends LoginHandler {

    public function __construct(Locator $locator) {
        parent::__construct($locator, Identity::FACEBOOK);
    }

    public function login(): string {

        // Retrieve Facebook configuration
        $Facebook = $this->locator->config->authenticationMethods->Facebook;

        $fb = new \Facebook\Facebook([
            'app_id' => $Facebook->id,
            'app_secret' => $Facebook->secret,
            'default_graph_version' => $Facebook->version,
        ]);

        $helper = $fb->getRedirectLoginHelper();

        $permissions = ['email']; // Optional permissions: we need user email

        $loginUrl = $helper->getLoginUrl($this->locator->getBasePath() . $Facebook->callback, $permissions);

        return $loginUrl;
    }

    public function retrieveToken(): string {
        // Retrieve Facebook configuration
        $Facebook = $this->locator->config->authenticationMethods->Facebook;

        $fb = new \Facebook\Facebook([
            'app_id' => $Facebook->id,
            'app_secret' => $Facebook->secret,
            'default_graph_version' => $Facebook->version,
        ]);

        $helper = $fb->getRedirectLoginHelper();
        if (isset($_GET['state'])) {
            $helper->getPersistentDataHandler()->set('state', $_GET['state']);
        }

        try {
            // obtaining current URL without query string
            $url = "https://$_SERVER[HTTP_HOST]" . strtok($_SERVER["REQUEST_URI"], '?');
            $accessToken = $helper->getAccessToken($url);
        } catch (Facebook\Exceptions\FacebookResponseException $e) {
            // When Graph returns an error
            http_response_code(500);
            die('Graph returned an error: ' . $e->getMessage());
        } catch (Facebook\Exceptions\FacebookSDKException $e) {
            // When validation fails or other local issues
            http_response_code(500);
            die('Facebook SDK returned an error: ' . $e->getMessage());
        }
        if (!isset($accessToken)) {
            if ($helper->getError()) {
                $errorMessage = "Error: " . $helper->getError() . "<br>";
                $errorMessage = $errorMessage . "Error Code: " . $helper->getErrorCode() . "<br>";
                $errorMessage = $errorMessage . "Error Reason: " . $helper->getErrorReason() . "<br>";
                $errorMessage = $errorMessage . "Error Description: " . $helper->getErrorDescription();
            } else {
                $errorMessage = "Bad request";
            }

            http_response_code(500);
            die($errorMessage);
        }

        try {
            // Returns a `Facebook\FacebookResponse` object
            $response = $fb->get('/me?fields=id,first_name,last_name,email', $accessToken);
        } catch (Facebook\Exceptions\FacebookResponseException $e) {
            echo 'Graph returned an error: ' . $e->getMessage();
            exit;
        } catch (Facebook\Exceptions\FacebookSDKException $e) {
            echo 'Facebook SDK returned an error: ' . $e->getMessage();
            exit;
        }

        $_SESSION['fb_access_token'] = (string) $accessToken;

        $fbUser = $response->getGraphUser();

        $typedId = $fbUser["id"];

        return $this->onIdentityDataReceived($typedId, function($identity) use($fbUser) {
                    $identity->email = $fbUser["email"];
                    $identity->name = $fbUser["first_name"];
                    $identity->surname = $fbUser["last_name"];
                });
    }

}
