/**
 * JS code included only in index.php page.
 */
// IIFE for keeping private functions and variables inside.
(function ($) {

    /**
     * Select the primary identity from the available identities of the user.
     * @param {int} index
     */
    window.setPrimaryIdentity = function (index) {
        $.post('primary-identity', {
            index: index
        }, function (response) {
            $('#panel-identities .panel-body').html(response);
            // restore tooltips (JS event handlers are deleted when DOM element
            // is replaced).
            loadTooltips();
        });
    };

    /**
     * Initialize Bootstrap tooltips.
     * As specified into Bootstrap documentation "For performance reasons, the
     * Tooltip and Popover data-apis are opt-in, meaning you must initialize
     * them yourself."
     */
    function loadTooltips() {
        $('.primary-identity-icon').tooltip();
        $('#join-btn').tooltip();
    }

    // When the document is loaded
    $(document).ready(function () {
        loadTooltips();
    });

})(jQuery);