CREATE TABLE `oauth2_client` (
  `id` int NOT NULL AUTO_INCREMENT,
  `title` varchar(255) NOT NULL,
  `icon` varchar(255),
  `client` varchar(255) NOT NULL,
  `secret` varchar(255) NOT NULL,
  `redirect_url` text NOT NULL,
  `scope` varchar(255) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE(client)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE `oauth2_client_auth_methods` (
  `client_id` int NOT NULL,
  `auth_method` varchar(50) NOT NULL,
  PRIMARY KEY (`client_id`, `auth_method`),
  FOREIGN KEY (`client_id`) REFERENCES `oauth2_client`(`id`)
);

CREATE TABLE `user` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `primary_identity` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE `identity` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `user_id` bigint(20) NOT NULL,
  `type` varchar(50) NOT NULL,
  `typed_id` varchar(255) NOT NULL,
  `email` varchar(255) NOT NULL,
  `name` varchar(255) DEFAULT NULL,
  `surname` varchar(255) DEFAULT NULL,
  `institution` varchar(255) DEFAULT NULL,
  `eppn` varchar(255) DEFAULT NULL,
  `tou_accepted` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  FOREIGN KEY (`user_id`) REFERENCES `user`(`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

SET FOREIGN_KEY_CHECKS=0;
ALTER TABLE `user` ADD FOREIGN KEY (`primary_identity`) REFERENCES `identity`(`id`);
SET FOREIGN_KEY_CHECKS=1;

CREATE TABLE `access_token` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `token` text NOT NULL,
  `user_id` text NOT NULL,
  `code` text NOT NULL,
  `creation_time` BIGINT NOT NULL DEFAULT UNIX_TIMESTAMP(),
  `expiration_time` BIGINT,
  `redirect_uri` text,
  `client_id` varchar(255),
  `scope` text,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE `rsa_keypairs` (
  `id` varchar(50) NOT NULL,
  `public_key` text,
  `private_key` text,
  `alg` varchar(255),
  `creation_time` BIGINT NOT NULL DEFAULT UNIX_TIMESTAMP(),
  PRIMARY KEY (`id`)
);

CREATE EVENT login_tokens_cleanup
    ON SCHEDULE
      EVERY 1 MINUTE
    COMMENT 'Remove expired login tokens'
    DO
      DELETE FROM login_token WHERE CURRENT_TIMESTAMP > TIMESTAMPADD(MINUTE,1,creation_time);
