<?php

include 'include/header.php';
?>

<script src="https://cdn.jsdelivr.net/npm/vue@2.6.10/dist/vue.js"></script>

<h1 class="text-center">Admin panel</h1>

<div id="admin-vue">
    <button class="btn btn-success pull-right" v-on:click="addNewOAuth2Client">
        <span class="glyphicon glyphicon-plus-sign"></span> Add client
    </button>
    <h2>OAuth2 clients</h2>
    <br/>
    <div class="panel panel-default" v-for="(client, index) in oauth2Clients">
        <div class="panel-heading">
            <button class="btn btn-danger pull-right" v-on:click="askConfirmDeleteOAuth2Client(client, index)">
                <span class="glyphicon glyphicon-trash"></span> Delete
            </button>
            <button class="btn btn-primary pull-right" v-on:click="editOAuth2Client(client)" v-if="!client.edit">
                <span class="glyphicon glyphicon-pencil"></span> Edit
            </button>
            <button class="btn btn-primary pull-right" v-on:click="saveOAuth2Client(client, index)" v-if="client.edit">
                <span class="glyphicon glyphicon-floppy-disk"></span> Save
            </button>
            <strong>{{client.title}} &nbsp;</strong>
        </div>
        <div class="panel-body">
            <div class="form-horizontal">
                <div class="form-group">
                    <label class="col-sm-3 control-label" for="title">Name</label>
                    <div class="col-sm-9">
                        <p class="form-control-static" v-if="!client.edit">{{client.title}}</p>
                        <input type="text" class="form-control" id="title" v-model="client.title" v-if="client.edit" />
                    </div>
                </div>
                <div class="form-group">
                    <label class="col-sm-3 control-label">Icon</label>
                    <div class="col-sm-9">
                        <p class="form-control-static" v-if="!client.edit">{{client.icon}}</p>
                    </div>
                </div>
                <div class="form-group">
                    <label class="col-sm-3 control-label" for="client_id">Client id</label>
                    <div class="col-sm-9">
                        <p class="form-control-static" v-if="!client.edit">{{client.client}}</p>
                        <input type="text" class="form-control" id="client_id" v-model="client.client" v-if="client.edit" />
                    </div>
                </div>
                <div class="form-group">
                    <label class="col-sm-3 control-label" for="client_secret">Client Secret</label>
                    <div class="col-sm-9">
                        <p class="form-control-static" v-if="!client.edit">{{client.secret}}</p>
                        <input type="text" class="form-control" id="client_secret" v-model="client.secret" v-if="client.edit" />
                    </div>
                </div>
                <div class="form-group">
                    <label class="col-sm-3 control-label" for="redirect_url">Redirect URL</label>
                    <div class="col-sm-9">
                        <p class="form-control-static" v-if="!client.edit">{{client.redirectUrl}}</p>
                        <input type="text" class="form-control" id="redirect_url" v-model="client.redirectUrl" v-if="client.edit" />
                    </div>
                </div>
                <div class="form-group">
                    <label class="col-sm-3 control-label" for="scope">Scope</label>
                    <div class="col-sm-9">
                        <p class="form-control-static" v-if="!client.edit">{{client.scope}}</p>
                        <input type="text" class="form-control" id="scope" v-model="client.scope" v-if="client.edit" />
                    </div>
                </div>
                <div class="form-group">
                    <label class="col-sm-3 control-label" for="authenticationMethods">Authentication methods</label>
                    <div class="col-sm-9">
                        <p class="form-control-static" v-if="!client.edit">{{getAuthMethodsString(client.authMethods)}}</p>
                        <div v-if="client.edit">
                            <div class="checkbox">
                                <label>
                                    <input type="checkbox" v-model="client.authMethods['eduGAIN']"> eduGAIN
                                </label>
                                <label>
                                    <input type="checkbox" v-model="client.authMethods['Google']"> Google
                                </label>
                                <label>
                                    <input type="checkbox" v-model="client.authMethods['Facebook']"> Facebook
                                </label>
                                <label>
                                    <input type="checkbox" v-model="client.authMethods['LinkedIn']"> LinkedIn
                                </label>
                                <label>
                                    <input type="checkbox" v-model="client.authMethods['X.509']"> X.509
                                </label>
                                <label>
                                    <input type="checkbox" v-model="client.authMethods['LocalIdP']"> LocalIdP
                                </label>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<script src="js/admin.js"></script>

<div class="modal fade" tabindex="-1" role="dialog" id="confirm-delete-client-modal">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
                <h4 class="modal-title">Confirm action</h4>
            </div>
            <div class="modal-body">
                <p>Are you sure that you want to delete the client <span id="client-to-delete"></span>?</p>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-danger" id="confirm-delete-client">Delete</button>
                <button type="button" class="btn btn-default" data-dismiss="modal">Cancel</button>
            </div>
        </div>
    </div>
</div>

<?php

include 'include/footer.php';
