<?php

/* ----------------------------------------------------------------------------
 *               INAF - National Institute for Astrophysics
 *               IRA  - Radioastronomical Institute - Bologna
 *               OATS - Astronomical Observatory - Trieste
 * ----------------------------------------------------------------------------
 *
 * Copyright (C) 2016 Istituto Nazionale di Astrofisica
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License Version 3 as published by the
 * Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 51
 * Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

namespace RAP;

class Identity {

    const EDU_GAIN = "eduGAIN";
    const X509 = "X.509";
    const GOOGLE = "Google";
    const FACEBOOK = "Facebook";
    const LINKEDIN = "LinkedIn";
    const LOCAL = "Local";

    private static $ALLOWED_TYPES = [Identity::EDU_GAIN, Identity::X509, Identity::GOOGLE, Identity::FACEBOOK, Identity::LINKEDIN, Identity::LOCAL];

    /**
     * Identity id in the database. Mandatory field.
     */
    public $id;

    /**
     * One of the types specified above. Mandatory field.
     */
    public $type;

    /**
     * Data related to specific account type (shibboleth persistent id, facebook id, etc, ...). Mandatory field.
     */
    public $typedId;

    /**
     * Primary email related to this identity. Mandatory field.
     * User can have additional email addresses. These are stored into User class.
     */
    public $email;

    /**
     * First name
     */
    public $name;

    /**
     * Last name / Family name
     */
    public $surname;

    /**
     * Institution / Organization. Not mandatory.
     */
    public $institution;

    /**
     * For eduGAIN identities.
     */
    public $eppn;

    /**
     * True if this has been selected as the primary identity.
     */
    public $primary;

    public function __construct($userType) {
        $isAllowedType = false;
        foreach (Identity::$ALLOWED_TYPES as $type) {
            if ($userType === $type) {
                $isAllowedType = true;
                break;
            }
        }
        if (!$isAllowedType) {
            throw new \Exception($userType . " is not a supported user type");
        }

        $this->type = $userType;

        $this->primary = false;
    }

}
