<?php

/* ----------------------------------------------------------------------------
 *               INAF - National Institute for Astrophysics
 *               IRA  - Radioastronomical Institute - Bologna
 *               OATS - Astronomical Observatory - Trieste
 * ----------------------------------------------------------------------------
 *
 * Copyright (C) 2016 Istituto Nazionale di Astrofisica
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License Version 3 as published by the
 * Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 51
 * Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

namespace RAP;

class MailSender {

    private $serverName;
    private $basePath;

    public function __construct($serverName, $basePath) {
        $this->serverName = $serverName;
        $this->basePath = $basePath;
    }

    public function sendJoinEmail(User $recipientUser, User $applicantUser, $token) {

        $subject = "IA2 RAP: Join request";

        $header = "From: noreply@" . $this->serverName . "\r\n";
        $header .= "Content-Type: text/html; charset=UTF-8";

        $confirmJoinURL = $this->basePath . '/confirm-join?token=' . $token;

        $body = "Dear IA2 user,<br/><br/>";
        $body .= "the following user requested to join your accounts on the "
                . "<a href=\"https://sso.ia2.inaf.it/rap-ia2/\" target=\"blank_\">RAP facility</a>:<br/><br/>";

        foreach ($applicantUser->identities as $identity) {

            $body .= "<b>Type</b>: " . $identity->type . "<br/>";

            if ($identity->name !== null) {
                $body .= "<b>Name</b>: " . $identity->name . "<br/>";
            }

            if ($identity->surname !== null) {
                $body .= "<b>Surname</b>: " . $identity->surname . "<br/>";
            }

            $body .= "<b>E-mail</b>: " . $identity->email . "<br/>";

            if ($identity->eppn !== null) {
                $body .= "<b>Eppn</b>: " . $identity->eppn . "<br/>";
            }

            if ($identity->institution !== null) {
                $body .= "<b>Institution</b>: " . $identity->institution . "<br/>";
            }

            $body .= "<br/>";
        }

        $body .= "<br/>If you and this user are <b>the same person</b> click on the following link for joining your accounts:<br/>";
        $body .= "<a href=\"$confirmJoinURL\" target=\"blank_\">$confirmJoinURL</a>";
        $body .= "<br/><br/>Otherwise you can ignore this email.<br/>";

        $body .= '<p><b>Please don\'t use this functionality for sharing resources between your coworkers</b>, use <a href="https://sso.ia2.inaf.it/grouper">Grouper</a> for that.</p>';
        $body .= '<br/>';

        $body .= "<b>*** This is an automatically generated email, please do not reply to this message ***</b><br/>";
        $body .= "If you need information please contact <a href=\"mailto:ia2@oats.inaf.it\">IA2 Staff</a>";

        mail($recipientUser->getPrimaryEmail(), $subject, $body, $header);
    }

}
