<?php

/* ----------------------------------------------------------------------------
 *               INAF - National Institute for Astrophysics
 *               IRA  - Radioastronomical Institute - Bologna
 *               OATS - Astronomical Observatory - Trieste
 * ----------------------------------------------------------------------------
 *
 * Copyright (C) 2016 Istituto Nazionale di Astrofisica
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License Version 3 as published by the
 * Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 51
 * Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

namespace RAP;

class SessionData {

    private $dao;
    private $callbackURL;
    private $callbackTitle;
    private $callbackLogo;
    public $user;
    public $userSearchResults;
    public $x509DataToRegister;

    public function __construct(DAO $dao) {
        $this->dao = $dao;
    }

    public function save() {
        $_SESSION['SessionData'] = $this;
    }

    public static function get(DAO $dao) {

        if (!isset($_SESSION['SessionData'])) {
            $session = new SessionData($dao);
            $session->save();
        }
        return $_SESSION['SessionData'];
    }

    public function setCallbackURL(CallbackHandler $callbackHandler, $callbackURL) {
        $this->callbackURL = $callbackHandler->filterCallbackURL($callbackURL);
        $this->callbackTitle = $callbackHandler->getCallbackTitle($callbackURL);
        $this->callbackLogo = $callbackHandler->getCallbackLogo($callbackURL);
        $this->save();
    }

    public function getCallbackURL() {
        return $this->callbackURL;
    }

    public function getCallbackTitle() {
        return $this->callbackTitle;
    }

    public function getCallbackLogo() {
        return $this->callbackLogo;
    }

    public function searchUser($searchText) {
        $users = $this->dao->searchUser($searchText);

        $this->userSearchResults = [];
        foreach ($users as $user) {
            // this search shouldn't contains the user itself
            if ($user->id !== $this->user->id) {
                $searchResult = UserSearchResult::buildFromUser($user);
                array_push($this->userSearchResults, $searchResult);
            }
        }

        $this->save();
    }

    public function updatePrimaryIdentity($identityId) {
        foreach ($this->user->identities as $identity) {
            $identity->primary = ($identity->id === $identityId);
        }
    }

}
