<?php

/**
 * REST backend for JavaScript code.
 */
//

function checkSession() {

    startSession();

    global $session;
    if ($session->user === null) {
        http_response_code(401);
        die("You must be registered to perform this action");
    }
}

Flight::route('GET /user', function() {

    checkSession();
    global $session;

    $searchText = Flight::request()->query['search'];
    $session->searchUser($searchText);

    $jsRes = [];
    foreach ($session->userSearchResults as $searchResult) {
        array_push($jsRes, $searchResult->userDisplayText);
    }

    echo json_encode($jsRes);
});

Flight::route('POST /join', function() {

    checkSession();
    global $session, $dao, $mailSender;

    $selectedUserIndex = Flight::request()->data['selectedUserIndex'];
    $selectedSearchResult = $session->userSearchResults[$selectedUserIndex];
    $targetUserId = $selectedSearchResult->getUser()->id;

    $token = RAP\Util::createNewToken();
    $dao->createJoinRequest($token, $session->user->id, $targetUserId);
    $mailSender->sendJoinEmail($selectedSearchResult->getUser(), $session->user, $token);

    echo $selectedSearchResult->userDisplayText;
});


Flight::route('POST /primary-identity', function() {

    checkSession();
    global $session, $dao;

    $identityId = Flight::request()->data['id'];

    $dao->setPrimaryIdentity($session->user->id, $identityId);
    $session->updatePrimaryIdentity($identityId);
    
    // Following variable is used to render user-data
    $user = $session->user;
    include 'user-data.php';
});
