<?php

/**
 * REST Web Service using http://flightphp.com/
 */
//
$WS_PREFIX = '/ws';

Flight::route('GET ' . $WS_PREFIX . '/user-info', function() {

    global $dao;

    $token = Flight::request()->query['token'];
    $userData = $dao->findLoginToken($token);

    if (is_null($userData)) {
        http_response_code(404);
        die("Token not found");
    }

    $dao->deleteLoginToken($token);

    header('Content-Type: text/plain');
    echo $userData;
});

Flight::route('GET ' . $WS_PREFIX . '/user/@userId', function($userId) {

    global $dao;

    $user = $dao->findUserById($userId);
    if ($user !== null) {
        header('Content-Type: application/json');
        echo json_encode($user);
    } else {
        http_response_code(404);
        die("User not found");
    }
});

Flight::route('GET ' . $WS_PREFIX . '/user', function() {

    global $dao;

    $searchText = Flight::request()->query['search'];
    $users = $dao->searchUser($searchText);
    echo json_encode($users);
});

/**
 * Create new user from identity data. Return the new user.
 */
Flight::route('POST ' . $WS_PREFIX . '/user', function() {

    global $userHandler;

    $postData = Flight::request()->data;

    $user = new RAP\User();

    $identity = new RAP\Identity($postData['type']);

    $identity->email = $postData['email'];
    $identity->typedId = $postData['typedId'];
    if (isset($postData['name'])) {
        $identity->name = $postData['name'];
    }
    if (isset($postData['surname'])) {
        $identity->surname = $postData['surname'];
    }
    if (isset($postData['institution'])) {
        $identity->institution = $postData['institution'];
    }
    if (isset($postData['eppn'])) {
        $identity->eppn = $postData['eppn'];
    }

    $user->addIdentity($identity);

    $userHandler->saveUser($user);

    echo json_encode($user);
});

Flight::route('POST ' . $WS_PREFIX . '/join', function() {

    global $userHandler;
    $postData = Flight::request()->data;

    $userHandler->joinUsers($postData['user1'], $postData['user2']);

    echo "Success";
});

Flight::route('GET ' . $WS_PREFIX . '/test', function() {
    
});
