<?php

/* ----------------------------------------------------------------------------
 *               INAF - National Institute for Astrophysics
 *               IRA  - Radioastronomical Institute - Bologna
 *               OATS - Astronomical Observatory - Trieste
 * ----------------------------------------------------------------------------
 *
 * Copyright (C) 2016 Istituto Nazionale di Astrofisica
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License Version 3 as published by the
 * Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 51
 * Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

/* LinkedIn callback page. Curl is used, because LinkedIn doesn't provide official PHP API. */

include '../../include/init.php';
startSession();

// Retrieve LinkedIn configuration
$LinkedIn = $AUTHENTICATION_METHODS['LinkedIn'];

if (!isset($_REQUEST['code'])) {
    die("Unable to get LinkedIn client code");
}

//create array of data to be posted to get AccessToken
$post_data = array(
    'grant_type' => "authorization_code",
    'code' => $_REQUEST['code'],
    'redirect_uri' => $LinkedIn['callback'],
    'client_id' => $LinkedIn['id'],
    'client_secret' => $LinkedIn['secret']);

//traverse array and prepare data for posting (key1=value1)
foreach ($post_data as $key => $value) {
    $post_items[] = $key . '=' . $value;
}

//create the final string to be posted
$post_string = implode('&', $post_items);

//create cURL connection
$conn1 = curl_init('https://www.linkedin.com/oauth/v2/accessToken');

//set options
curl_setopt($conn1, CURLOPT_CONNECTTIMEOUT, 30);
curl_setopt($conn1, CURLOPT_RETURNTRANSFER, true);
curl_setopt($conn1, CURLOPT_SSL_VERIFYPEER, true);
curl_setopt($conn1, CURLOPT_FOLLOWLOCATION, 1);

//set data to be posted
curl_setopt($conn1, CURLOPT_POSTFIELDS, $post_string);

//perform our request
$result1 = curl_exec($conn1);
$info1 = curl_getinfo($conn1);

if ($info1['http_code'] === 200) {
    $my_token = json_decode($result1, TRUE);
    $access_token = $my_token['access_token'];
    $expires_in = $my_token['expires_in'];
    curl_close($conn1);
} else {
    //show information regarding the error
    $errorMessage = "Error: LinkedIn server response code: " . $info1['http_code'] . " - ";
    $errorMessage .= curl_error($conn1);
    curl_close($conn1);
    http_response_code(500);
    die($errorMessage);
}

// Call to API
$conn2 = curl_init();
curl_setopt($conn2, CURLOPT_URL, "https://api.linkedin.com/v2/me");
curl_setopt($conn2, CURLOPT_HTTPHEADER, array(
    'Authorization: Bearer ' . $access_token
));

curl_setopt($conn2, CURLOPT_RETURNTRANSFER, true);
$result = curl_exec($conn2);
$info2 = curl_getinfo($conn2);

if ($info2['http_code'] === 200) {
    $data = json_decode($result, TRUE);

    curl_close($conn2);

    if (isset($data['errorCode'])) {
        $errorMessage = $data['message'];
        die($errorMessage);
    }

    $typedId = $data['id'];

    // Search if the user is already registered into RAP using the LinkedIn ID.
    $user = $userHandler->findUserByIdentity(RAP\Identity::LINKEDIN, $typedId);

    if ($user === null) {

      // Recall to API for email
      $conn2 = curl_init();
      curl_setopt($conn2, CURLOPT_URL, "https://api.linkedin.com/v2/emailAddress?q=members&projection=(elements*(handle~))");
      curl_setopt($conn2, CURLOPT_HTTPHEADER, array(
           'Authorization: Bearer ' . $access_token
      ));

      curl_setopt($conn2, CURLOPT_RETURNTRANSFER, true);
      $result = curl_exec($conn2);
      $info2 = curl_getinfo($conn2);

      if ($info2['http_code'] === 200) {
        $data2 = json_decode($result, TRUE);

        curl_close($conn2);

        if (isset($data['errorCode'])) {
          $errorMessage = $data['message'];
          die($errorMessage);
        }
      } else {
           //show information regarding the error
           $errorMessage = "Error: LinkedIn server response code: " . $info2['http_code'] . " - ";
           $errorMessage = $errorMessage . curl_error($conn2);
           curl_close($conn2);
           die($errorMessage);
      }
        // Create new user
        $user = new RAP\User();

        $identity = new RAP\Identity(RAP\Identity::LINKEDIN);
        $identity->email = $data2['elements'][0]['handle~']['emailAddress'];
        $identity->name = $data['localizedFirstName'];
        $identity->surname = $data['localizedLastName'];
        $identity->typedId = $typedId;

        $user->addIdentity($identity);

        $session->userToLogin = $user;
        $session->save();
        header('Location: ' . $BASE_PATH . '/tou-check');
        die();
    }

    $auditLog->info("LOGIN,LinkedIn," . $user->id);
    $callbackHandler->manageLoginRedirect($user, $session);
} else {
    //show information regarding the error
    $errorMessage = "Error: LinkedIn server response code: " . $info2['http_code'] . " - ";
    $errorMessage = $errorMessage . curl_error($conn2);
    curl_close($conn2);
    die($errorMessage);
}
?>
