<?php
include 'include/header.php';
?>
<script src="js/index.js?v=<?php echo $version; ?>"></script>

<?php if ($session->user === null) { ?>
    <div class="row">
        <div class="col-xs-12">
            <h1 class="text-center page-title">
                <?php
                if ($session->getCallbackLogo() != null) {
                    ?>
                    <img class="service-logo" src="service-logos/<?php echo $session->getCallbackLogo(); ?>" alt="" />
                    <?php
                }
                echo $session->getCallbackTitle();
                ?>
            </h1>
        </div>
    </div>

    <?php
        if ($session->getCallbackAuth() != null) {
            $authType = $session->getCallbackAuth();
        }
    ?>
    <div class="row" id="auth-panel">
        <div class="col-xs-12 text-center">
            <?php if (isset($auth['eduGAIN']) and 
                    ( !isset($authType) or in_array('eduGAIN', $authType))) { ?>
                <div class="home-box">
                    <div class="img-wrapper">
                        <a href="edugain?callback=<?php echo $session->getCallbackURL(); ?>">
                            <img src="img/eduGain-200.png" alt="eduGAIN Logo" />
                        </a>
                    </div>
                    Use the eduGAIN Logo to Login or Register to the RAP facility if you belong to an eduGAIN IdP.
                </div>
            <?php } ?>
            <?php if (isset($auth['Google']) || isset($auth['Facebook']) || isset($auth['LinkedIn'])) { ?>
                <div class="home-box">
                    <div class="img-wrapper">
                        <?php if (isset($auth['Google']) and 
                                 ( !isset($authType) or 
                                   in_array('Google', $authType))) { ?>
                            <a href="google?callback=<?php echo $session->getCallbackURL(); ?>" class="animated pulse">
                        <?php if ((isset($auth['Facebook']) and
                                  ( !isset($authType) or 
                                    in_array('Facebook', $authType))) or
                                  (isset($auth['LinkedIn']) and
                                  ( !isset($authType) or 
                                    in_array('LinkedIn', $authType))))  { ?>
                                <img src="img/google-60.png" alt="Google Logo" />
                            </a>
                        <?php } else {?>
                                <img src="img/google-200.png" alt="Google Logo" />
                            </a>
                        <?php } } ?>
                        <?php if (isset($auth['Facebook']) and
                                 ( !isset($authType) or 
                                   in_array('Facebook', $authType))) { ?>
                            <a href="facebook?callback=<?php echo $session->getCallbackURL(); ?>">
                        <?php if ((isset($auth['Google']) and
                                  ( !isset($authType) or 
                                    in_array('Google', $authType))) or
                                  (isset($auth['LinkedIn']) and
                                  ( !isset($authType) or 
                                    in_array('LinkedIn', $authType))))  { ?>
                                <img src="img/facebook-60.png" alt="Facebook Logo" />
                            </a>
                        <?php } else {?>
                                <img src="img/facebook-200.png" alt="Facebook Logo" />
                            </a>
                        <?php } } ?>
                        <?php if (isset($auth['LinkedIn']) and
                                 ( !isset($authType) or 
                                   in_array('LinkedIn', $authType))) { ?>
                            <a href="linkedin?callback=<?php echo $session->getCallbackURL(); ?>">
                        <?php if ((isset($auth['Facebook']) and
                                  ( !isset($authType) or 
                                    in_array('Facebook', $authType))) or
                                  (isset($auth['Google']) and
                                  ( !isset($authType) or 
                                    in_array('Google', $authType))))  { ?>
                                <img src="img/linkedin-60.png" alt="LinkedIn Logo" />
                            </a>
                        <?php } else {?>
                                <img src="img/linkedin-200.png" alt="LinkedIn Logo" />
                            </a>
                        <?php } } ?>
                    </div>
                    Use these Logos to Login or Register to the RAP facility with your social identity
                </div>
            <?php } ?>
            <?php if (isset($auth['X.509']) and
                    ( !isset($authType) or in_array('X.509', $authType))) { ?>
                <div class="home-box">
                    <div class="img-wrapper">
                        <a href="x509?callback=<?php echo $session->getCallbackURL(); ?>">
                            <img src="img/x509-200.png" alt="X.509 Logo" />
                        </a>
                    </div>
                    Use the X.509 Logo to Login with your personal certificate (IGTF and TERENA-TACAR, are allowed).
                </div>
            <?php } ?>
            <?php if (isset($auth['DirectIdP']) and (!isset($authType) or 
                                      in_array('DirectIdP', $authType))) { ?>
                <div class="home-box">
                    <div class="img-wrapper">
                        <a href="direct?callback=<?php echo $session->getCallbackURL(); ?>">
                            <img src="<?php echo $auth['DirectIdP']['logo']; ?>" alt="<?php echo $auth['DirectIdP']['logo_alt']; ?>" />
                        </a>
                    </div>
                    <?php echo $auth['DirectIdP']['description']; ?>
                </div>
            <?php } ?>
        </div>
    </div>
<?php } else { ?>
    <div class="row">
        <div class="col-xs-12">
            <div class="alert alert-success hide" id="info-message-alert">
                <button type="button" class="close" aria-label="Close"><span aria-hidden="true">&times;</span></button>
                <span class="glyphicon glyphicon-info-sign"></span>
                <span class="info-message"></span>
            </div>
        </div>
    </div>
    <div class="row">
        <div class="col-sm-5 col-xs-12">
            <div class="panel panel-default" id="panel-identities">
                <div class="panel-heading">
                    <h3 class="panel-title">Your identities</h3>
                </div>
                <div class="panel-body">
                    <?php
                    $user = $session->user;
                    include 'include/user-data.php';
                    ?>
                </div>
            </div>
        </div>
        <div class="col-sm-2 text-center">
            <button class="btn btn-success" type="button" data-toggle="modal" data-target="#search-user-modal">
                Join with another identity
            </button>
        </div>
        <div class="col-sm-5">
            <a href="logout" class="btn btn-primary pull-right">Logout</a>
        </div>
    </div>

    <div class="modal fade" id="search-user-modal" tabindex="-1" role="dialog" aria-labelledby="search-user-modal-title">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
                    <h4 class="modal-title" id="search-user-modal-title">Search user</h4>
                </div>
                <div class="modal-body">
                    <form class="form-horizontal">
                        <div class="form-group">
                            <label for="user-search-text" class="col-xs-3 control-label">Search text</label>
                            <div class="col-xs-9">
                                <input type="text" class="form-control" id="user-search-text" placeholder="Name, surname or email...">
                            </div>
                        </div>
                        <div class="form-group hide" id="user-selector-group">
                            <label for="user-selector" class="col-xs-3 control-label">Select user</label>
                            <div class="col-xs-9">
                                <select id="user-selector" class="form-control">

                                </select>
                            </div>
                        </div>
                    </form>
                </div>
                <div class="modal-footer">
                    <button class="btn btn-primary" type="button" id="send-join-request-btn">
                        Send join request
                    </button>
                </div>
            </div>
        </div>
    </div>
<?php } ?>

<script>
    $(document).on('click', '#auth-panel a', showWaiting);
</script>

<?php
include 'include/footer.php';

