<?php

/* ----------------------------------------------------------------------------
 *               INAF - National Institute for Astrophysics
 *               IRA  - Radioastronomical Institute - Bologna
 *               OATS - Astronomical Observatory - Trieste
 * ----------------------------------------------------------------------------
 *
 * Copyright (C) 2016 Istituto Nazionale di Astrofisica
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License Version 3 as published by the
 * Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 51
 * Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

/**
 * Initialization file called by all the other pages.
 */
define('ROOT', dirname(dirname(__FILE__)));

// Defining autoload for RAP classes
spl_autoload_register(function ($class) {
    $prefix = "RAP\\";
    $len = strlen($prefix);

    if (strncmp($prefix, $class, $len) === 0) {

        $fileName = substr($class, $len, strlen($class) - $len);

        $classDirectories = ['/', '/social/', '/exceptions/'];
        foreach ($classDirectories as $directory) {
            $classpath = ROOT . '/classes' . $directory . $fileName . '.php';
            if (file_exists($classpath)) {
                require_once $classpath;
            }
        }
    }
});

// Loading dependecy classes
include ROOT . '/vendor/autoload.php';

// Loading configuration
$config = json_decode(file_get_contents(ROOT . '/config.json'));

// Generating locator (global registry)
$locator = new \RAP\Locator($config);
