<?php

namespace RAP;

/**
 * CRUD methods for OAuth2Clients (used by admin interface).
 */
interface OAuth2ClientDAO {

    function getOAuth2Clients(): array;

    function createOAuth2Client(OAuth2Client $client): OAuth2Client;

    function updateOAuth2Client(OAuth2Client $client): OAuth2Client;

    function deleteOAuth2Client($clientId);

    /**
     * Retrieve the client from the configured client id (the one associated to
     * the secret, not the database id).
     */
    function getOAuth2ClientByClientId($clientId): ?OAuth2Client;
}
