<?php

namespace RAP;

class RefreshToken {

    private const TOKEN_LIFESPAN = 2 * 3600;

    public function __construct() {
        $this->creationTime = time();
        $this->expirationTime = $this->creationTime + RefreshToken::TOKEN_LIFESPAN;
    }

    public $token;
    public $userId;
    public $creationTime;
    public $expirationTime;
    public $expired;
    public $clientId;
    public $scope;

    public function isExpired(): bool {
        return $this->expirationTime < time();
    }

}
