<?php

namespace RAP;

use \Firebase\JWT\JWT;

class IdTokenBuilder {

    private $locator;

    public function __construct(Locator $locator) {
        $this->locator = $locator;
    }

    public function getIdToken(AccessToken $accessToken, string $alg): string {

        $head = array("alg" => $alg, "typ" => "JWT");

        $header = base64_encode(json_encode($head));

        $keyPair = $this->locator->getJWKSDAO()->getNewestKeyPair();

        $payloadArr = $this->createPayloadArray($accessToken);
        $payloadArr['kid'] = $keyPair->keyId;

        $payload = base64_encode(json_encode($payloadArr));

        $token_value = $header . "." . $payload;

        return JWT::encode($token_value, $keyPair->privateKey, $alg);
    }

    private function createPayloadArray(AccessToken $accessToken) {

        $user = $this->locator->getDAO()->findUserById($accessToken->userId);

        $payloadArr = array(
            'iss' => $this->locator->config->jwtIssuer,
            'sub' => $user->id,
            'iat' => time(),
            'exp' => time() + 120,
            'name' => $user->getCompleteName()
        );

        if (in_array("email", $accessToken->scope)) {
            $payloadArr['email'] = $user->getPrimaryEmail();
        }
        if (in_array("profile", $accessToken->scope)) {
            $payloadArr['given_name'] = $user->getName();
            $payloadArr['family_name'] = $user->getSurname();
            $payloadArr['org'] = $user->getInstitution();
        }

        return $payloadArr;
    }

}
