<?php

namespace RAP;

use phpseclib\Crypt\RSA;

/**
 * Manages the JWT Key Sets (currently only RSA .
 */
class JWKSHandler {

    private $locator;

    public function __construct(Locator $locator) {
        $this->locator = $locator;
    }

    public function generateKeyPair() {

        $rsa = new RSA();

        $rsa->setPrivateKeyFormat(RSA::PRIVATE_FORMAT_PKCS1);
        $rsa->setPublicKeyFormat(RSA::PUBLIC_FORMAT_PKCS1);
        $result = $rsa->createKey();

        $keyPair = new RSAKeyPair();
        $keyPair->alg = 'RS256';
        $keyPair->privateKey = $result['privatekey'];
        $keyPair->publicKey = $result['publickey'];
        $keyPair->keyId = bin2hex(random_bytes(8));

        $dao = $this->locator->getJWKSDAO();
        $dao->insertRSAKeyPair($keyPair);

        return $keyPair;
    }

    public function getJWKS() {

        $dao = $this->locator->getJWKSDAO();

        $keyPairs = $dao->getRSAKeyPairs();

        $jwks = [];
        foreach ($keyPairs as $keyPair) {

            $publicKey = str_replace("\n", "", $keyPair->publicKey);
            $publicKey = str_replace("\r", "", $publicKey);
            $publicKey = str_replace('-----BEGIN RSA PUBLIC KEY-----', '', $publicKey);
            $publicKey = str_replace('-----END RSA PUBLIC KEY-----', '', $publicKey);

            $jwk = [];
            $jwk['kty'] = "RSA";
            $jwk['kid'] = $keyPair->id;
            $jwk['use'] = "sig";
            $jwk['n'] = $publicKey;
            $jwk['e'] = "AQAB";

            array_push($jwks, $jwk);
        }

        return $jwks;
    }

}
