<?php

namespace RAP;

interface AccessTokenDAO {

    /**
     * Store a new login token into the database.
     * @param type $token login token
     * @param type $userId
     */
    function createAccessToken(AccessToken $accessToken): AccessToken;

    function retrieveAccessTokenFromCode(string $code): ?AccessToken;

    /**
     * Delete an access token from the database. This happens when the caller
     * application has received the token and used it for retrieving user
     * information from the token using the RAP REST web service.
     * @param type $token login token
     */
    function deleteAccessToken(string $token): void;
}
