<?php

use PHPUnit\Framework\TestCase;

final class IdTokenBuilderTest extends TestCase {

    public function testJWTCreation() {

        $jwksDAOStub = $this->createMock(\RAP\JWKSDAO::class);

        $locatorStub = $this->createMock(\RAP\Locator::class);
        $locatorStub->method('getJWKSDAO')->willReturn($jwksDAOStub);

        $jwksHandler = new \RAP\JWKSHandler($locatorStub);
        $keyPair = $jwksHandler->generateKeyPair();

        $jwksDAOStub->method('getNewestKeyPair')->willReturn($keyPair);

        $user = new \RAP\User();
        $user->id = "user_id";
        $identity = new \RAP\Identity(\RAP\Identity::EDU_GAIN);
        $identity->email = "name@inaf.it";
        $identity->name = "Name";
        $identity->surname = "Surname";
        $identity->primary = true;
        $user->addIdentity($identity);

        $daoStub = $this->createMock(\RAP\DAO::class);
        $locatorStub->method('getDAO')->willReturn($daoStub);
        $daoStub->method('findUserById')->willReturn($user);

        $locatorStub->config = json_decode('{"jwtIssuer": "issuer"}');

        $accessToken = new \RAP\AccessToken();
        $accessToken->token = "ttt";
        $accessToken->scope = ["email", "profile"];
        $accessToken->userId = "user_id";

        $tokenBuilder = new \RAP\IdTokenBuilder($locatorStub);
        $result = $tokenBuilder->getIdToken($accessToken, 'RS256');

        $this->assertNotNull($result);
    }

}
