<?php
include 'include/header.php';
?>
<script src="js/index.js?v=<?php echo $version; ?>"></script>

<div class="row">
    <div class="col-xs-12">
        <h1 class="text-center page-title">
            <?php
            if ($model->clientIcon != null) {
                ?>
                <img class="service-logo" src="<?php echo $model->clientIcon; ?>" alt="" />
                <?php
            }
            echo $model->clientTitle;
            ?>
        </h1>
    </div>
</div>
<div class="row" id="auth-panel">
    <div class="col-xs-12 text-center">
        <?php if ($model->eduGAIN) { ?>
            <div class="home-box">
                <div class="img-wrapper">
                    <a href="edugain">
                        <img src="img/eduGain-200.png" alt="eduGAIN Logo" />
                    </a>
                </div>
                Use the eduGAIN Logo to Login or Register to the RAP facility if you belong to an eduGAIN IdP.
            </div>
        <?php } ?>
        <?php if ($model->google || $model->facebook || $model->linkedIn) { ?>
            <div class="home-box">
                <div class="img-wrapper">
                    <?php if ($model->google) { ?>
                        <a href="auth/social/google" class="animated pulse">
                            <img src="img/google-60.png" alt="Google Logo" />
                        </a>
                    <?php } ?>
                    <?php if ($model->facebook) { ?>
                        <a href="facebook">
                            <img src="img/facebook-60.png" alt="Facebook Logo" />
                        </a>
                    <?php } ?>
                    <?php if ($model->linkedIn) { ?>
                        <a href="linkedin">
                            <img src="img/linkedin-60.png" alt="LinkedIn Logo" />
                        </a>
                    <?php } ?>
                </div>
                Use these Logos to Login or Register to the RAP facility with your social identity
            </div>
        <?php } ?>
        <?php if ($model->x509) { ?>
            <div class="home-box">
                <div class="img-wrapper">
                    <a href="x509">
                        <img src="img/x509-200.png" alt="X.509 Logo" />
                    </a>
                </div>
                Use the X.509 Logo to Login with your personal certificate (IGTF and TERENA-TACAR, are allowed).
            </div>
        <?php } ?>
        <?php if ($model->localIdP) { ?>
            <div class="home-box">
                <div class="img-wrapper">
                    <a href="local">
                        <img src="<?php echo $model->localIdPConfig->logo; ?>" alt="<?php echo $model->localIdPConfig->logoAlt; ?>" />
                    </a>
                </div>
                <?php echo $model->localIdPConfig->description; ?>
            </div>
        <?php } ?>
    </div>
</div>

<script>
    $(document).on('click', '#auth-panel a', showWaiting);
</script>

<?php
include 'include/footer.php';

