<?php

namespace RAP;

use \Firebase\JWT\JWT;

class IdTokenBuilder {

    private $locator;

    public function __construct(Locator $locator) {
        $this->locator = $locator;
    }

    public function getIdToken(AccessToken $accessToken): string {

        $keyPair = $this->locator->getJWKSDAO()->getNewestKeyPair();

        $payload = $this->createPayloadArray($accessToken);

        return JWT::encode($payload, $keyPair->privateKey, $keyPair->alg, $keyPair->keyId);
    }

    private function createPayloadArray(AccessToken $accessToken) {

        $user = $this->locator->getDAO()->findUserById($accessToken->userId);

        $payloadArr = array(
            'iss' => $this->locator->config->jwtIssuer,
            'sub' => $user->id,
            'iat' => time(),
            'exp' => time() + 120,
            'name' => $user->getCompleteName()
        );

        if (in_array("email", $accessToken->scope)) {
            $payloadArr['email'] = $user->getPrimaryEmail();
        }
        if (in_array("profile", $accessToken->scope)) {
            $payloadArr['given_name'] = $user->getName();
            $payloadArr['family_name'] = $user->getSurname();
            if ($user->getInstitution() !== null) {
                $payloadArr['org'] = $user->getInstitution();
            }
        }

        return $payloadArr;
    }

}
