<?php
include 'include/header.php';
?>
<script src="js/index.js?v=<?php echo $version; ?>"></script>

<div class="row">
    <div class="col-xs-12">
        <div class="alert alert-success hide" id="info-message-alert">
            <button type="button" class="close" aria-label="Close"><span aria-hidden="true">&times;</span></button>
            <span class="glyphicon glyphicon-info-sign"></span>
            <span class="info-message"></span>
        </div>
    </div>
</div>
<div class="row">
    <div class="col-sm-5 col-xs-12">
        <div class="panel panel-default" id="panel-identities">
            <div class="panel-heading">
                <h3 class="panel-title">Your identities</h3>
            </div>
            <div class="panel-body">
                <?php
                $user = $session->user;
                include 'include/user-data.php';
                ?>
            </div>
        </div>
    </div>
    <div class="col-sm-2 text-center">
        <button class="btn btn-success" type="button" data-toggle="modal" data-target="#search-user-modal">
            Join with another identity
        </button>
    </div>
    <div class="col-sm-5">
        <a href="logout" class="btn btn-primary pull-right">Logout</a>
    </div>
</div>

<div class="modal fade" id="search-user-modal" tabindex="-1" role="dialog" aria-labelledby="search-user-modal-title">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
                <h4 class="modal-title" id="search-user-modal-title">Search user</h4>
            </div>
            <div class="modal-body">
                <form class="form-horizontal">
                    <div class="form-group">
                        <label for="user-search-text" class="col-xs-3 control-label">Search text</label>
                        <div class="col-xs-9">
                            <input type="text" class="form-control" id="user-search-text" placeholder="Name, surname or email...">
                        </div>
                    </div>
                    <div class="form-group hide" id="user-selector-group">
                        <label for="user-selector" class="col-xs-3 control-label">Select user</label>
                        <div class="col-xs-9">
                            <select id="user-selector" class="form-control">

                            </select>
                        </div>
                    </div>
                </form>
            </div>
            <div class="modal-footer">
                <button class="btn btn-primary" type="button" id="send-join-request-btn">
                    Send join request
                </button>
            </div>
        </div>
    </div>
</div>

<?php
include 'include/footer.php';