<?php

/* ----------------------------------------------------------------------------
 *               INAF - National Institute for Astrophysics
 *               IRA  - Radioastronomical Institute - Bologna
 *               OATS - Astronomical Observatory - Trieste
 * ----------------------------------------------------------------------------
 *
 * Copyright (C) 2016 Istituto Nazionale di Astrofisica
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License Version 3 as published by the
 * Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 51
 * Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

include '../../include/init.php';
startSession();

if (isset($_SERVER['Shib-Session-ID'])) {

    $eppn = $_SERVER['eppn'];

    $user = $userHandler->findUserByIdentity(RAP\Identity::EDU_GAIN, $eppn);

    if ($user === null) {
        $user = new RAP\User();

        $identity = new RAP\Identity(RAP\Identity::EDU_GAIN);
        $identity->email = $_SERVER['mail'];
        $identity->name = $_SERVER['givenName'];
        $identity->surname = $_SERVER['sn'];
        $identity->typedId = $eppn;
        $identity->eppn = $eppn;
        //$_SERVER['Shib-Identity-Provider']

        $user->addIdentity($identity);

        $userHandler->saveUser($user);
    }

    $callbackHandler->manageLoginRedirect($user, $session);
} else {
    http_response_code(500);
    die("Shib-Session-ID not found!");
}
