<?php

/* ----------------------------------------------------------------------------
 *               INAF - National Institute for Astrophysics
 *               IRA  - Radioastronomical Institute - Bologna
 *               OATS - Astronomical Observatory - Trieste
 * ----------------------------------------------------------------------------
 *
 * Copyright (C) 2016 Istituto Nazionale di Astrofisica
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License Version 3 as published by the
 * Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 51
 * Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

namespace RAP;

interface DAO {

    function getDBHandler();

    function createLoginToken($token, $userId);

    function findLoginToken($token);

    function deleteLoginToken($token);

    /**
     * Return the new identity ID.
     */
    function insertIdentity(Identity $identity, $userId);

    /**
     * Return the new user ID.
     */
    function createUser();

    function findUserById($userId);

    function setPrimaryIdentity($userId, $identityId);

    /**
     * Return a User object, null if nothing was found.
     * @param type $type Identity type (EDU_GAIN, X509, GOOGLE, ...)
     * @param type $identifier value used to search the identity in the database
     */
    function findUserByIdentity($type, $identifier);

    function searchUser($searchText);

    function createJoinRequest($token, $applicantUserId, $targetUserId);

    function findJoinRequest($token);

    function deleteUser($userId);

    function joinUsers($userId1, $userId2);

    function deleteJoinRequest($token);
}
