<?php

/**
 * Front Controller using http://flightphp.com/
 * In all these calls user session must exist, so we have to start it at the 
 * beginning using the startSession() function.
 */
//

function setCallback() {
    global $session, $callbackHandler;

    $callback = Flight::request()->data['callback'];
    $session->setCallbackURL($callbackHandler, isset($callback) ? $callback : null);
}

Flight::route('/', function() {
    startSession();
    setCallback();
    global $session, $AUTHENTICATION_METHODS;
    Flight::render('index.php', array('title' => 'RAP',
        'session' => $session, 'auth' => $AUTHENTICATION_METHODS));
});

Flight::route('GET /logout', function() {
    startSession();
    session_destroy();
    Flight::redirect('/');
});

Flight::route('/google', function() {
    startSession();
    Flight::redirect('/auth/oauth2/google_token.php');
});

Flight::route('/facebook', function() {
    startSession();
    Flight::redirect('/auth/oauth2/facebook_login.php');
});

Flight::route('/eduGAIN', function() {
    startSession();
    Flight::redirect('/auth/saml2/aai.php');
});

Flight::route('/x509', function() {
    startSession();
    Flight::redirect('/auth/x509/certlogin.php');
});

Flight::route('GET /confirm-join', function() {
    $token = Flight::request()->query['token'];

    if ($token === null) {
        http_response_code(422);
        die("Token not found");
    }

    global $dao;

    $userIds = $dao->findJoinRequest($token);
    if ($userIds === null) {
        http_response_code(422);
        die("Invalid token");
    }

    $applicantUser = $dao->findUserById($userIds[0]);
    $targetUser = $dao->findUserById($userIds[1]);

    Flight::render('confirm-join.php', array('title' => 'RAP',
        'token' => $token,
        'applicantUser' => $applicantUser,
        'targetUser' => $targetUser));
});

Flight::route('POST /confirm-join', function() {

    global $dao, $userHandler;

    $token = Flight::request()->data['token'];

    if ($token === null) {
        http_response_code(422);
        die("Token not found");
    }

    $userIds = $dao->findJoinRequest($token);
    if ($userIds === null) {
        http_response_code(422);
        die("Invalid token");
    }

    $userHandler->joinUsers($userIds[0], $userIds[1]);
    $dao->deleteJoinRequest($token);

    // Force user to relogin to see changes to him/her identities
    session_start();
    session_destroy();

    global $BASE_PATH;
    Flight::render('join-success.php', array('title' => 'Success - RAP Join Request',
        'basePath' => $BASE_PATH));
});

Flight::route('GET /x509-name-surname', function() {

    startSession();
    global $session, $BASE_PATH;

    if ($session->x509DataToRegister !== null && $session->x509DataToRegister->name === null) {
        Flight::render('x509-name-surname.php', array('title' => 'Select name and surname',
            'fullName' => $session->x509DataToRegister->fullName,
            'candidateNames' => $session->x509DataToRegister->candidateNames));
    } else {
        // Redirect to index
        header("Location: " . $BASE_PATH);
    }
});

Flight::route('POST /submit-x509-name', function() {

    $selectedNameIndex = Flight::request()->data['selected-name'];

    startSession();
    global $session, $BASE_PATH;

    if ($session->x509DataToRegister !== null) {
        $session->x509DataToRegister->selectCandidateName($selectedNameIndex);
        header("Location: " . $BASE_PATH . '/x509');
    }
});
