<?php

/**
 * REST Web Service using http://flightphp.com/
 */
//
$WS_PREFIX = '/ws';

Flight::route('GET ' . $WS_PREFIX . '/user-info', function() {

    global $dao;

    $token = Flight::request()->query['token'];
    $userData = $dao->findLoginToken($token);

    if (is_null($userData)) {
        http_response_code(404);
        die("Token not found");
    }

    $dao->deleteLoginToken($token);

    header('Content-Type: text/plain');
    echo $userData;
});

Flight::route('GET ' . $WS_PREFIX . '/user/@userId', function($userId) {

    global $dao;

    $user = $dao->findUserById($userId);
    if ($user !== null) {
        header('Content-Type: application/json');
        echo json_encode($user);
    } else {
        http_response_code(404);
        die("User not found");
    }
});

Flight::route('GET ' . $WS_PREFIX . '/user', function() {

    global $dao;
    
    $searchText = Flight::request()->query['search'];
    $users = $dao->searchUser($searchText);
    echo json_encode($users);
});

Flight::route('GET ' . $WS_PREFIX . '/test', function() {
});
