(function ($) {

    // function factory used to generate function to be executed at timeout (see below)
    function searchUserFactory(searchText) {
        return function () {
            $.get('user?search=' + searchText, function (response) {
                var users = JSON.parse(response);

                // Display the selector only if we have some results
                $('#user-selector-group').toggleClass('hide', users.length === 0);

                // Fill the user selector
                $userSelector = $('#user-selector-group select');
                $userSelector.empty();
                for (var i = 0; i < users.length; i++) {
                    $userSelector.append('<option value="' + i + '">' + users[i] + '</option>');
                }
            });
        };
    }

    function sendJoinRequest() {

        $userSelector = $('#user-selector-group select');
        var selectedUserIndex = $userSelector.val();

        if (selectedUserIndex !== null) {
            $.post('join', {selectedUserIndex: selectedUserIndex}, function (response) {
                $('#search-user-modal').modal('hide');
                $infoAlert = $('#info-message-alert');
                $infoAlert.find('.info-message').text("An e-mail has been sent to " + response + " primary e-mail address.");
                $infoAlert.removeClass('hide');
            });
        }
    }

    window.setPrimaryIdentity = function (identityId) {
        $.post('primary-identity', {
            id: identityId
        }, function (response) {
            $('#panel-identities .panel-body').html(response);
            // restore tooltips
            loadTooltips();
        });
    };

    function loadTooltips() {
        $('.primary-identity-icon').tooltip();
    }

    // When the document is loaded
    $(document).ready(function () {

        // Add keyup event handler on user search input text
        var timeoutId = 0;
        $(document).on('keyup', '#user-search-text', function (event) {
            clearTimeout(timeoutId);
            var searchUser = searchUserFactory($(event.target).val());
            // wait 500 ms without typing before doing the AJAX call
            timeoutId = setTimeout(searchUser, 500);
        });

        // Add click event handler to join request button
        $(document).on('click', '#send-join-request-btn', sendJoinRequest);

        $(document).on('click', '#info-message-alert .close', function () {
            $('#info-message-alert').addClass('hide');
        });

        loadTooltips();
    });

})(jQuery);