<?php

namespace RAP;

class ShibbolethLogin extends LoginHandler {

    public function __construct(Locator $locator) {
        parent::__construct($locator, Identity::EDU_GAIN);
    }

    public function login() {
        if (isset($_SERVER['Shib-Session-ID'])) {

            // Retrieving eduPersonPrincipalName (eppn)
            $eppn = $_SERVER['eppn'];

            // Search if the user is already registered into RAP using the eppn.
            // The persistent id should be a more appropriate identifier, however at IA2
            // we need to import all INAF user into RAP, even if they will never register,
            // and in that case we know only their eppn.

            $this->onIdentityDataReceived($eppn, function($identity) use($eppn) {
                $identity->email = $_SERVER['mail'];
                $identity->name = $_SERVER['givenName'];
                $identity->surname = $_SERVER['sn'];
                $identity->eppn = $eppn;
            });
        } else {
            http_response_code(500);
            die("Shib-Session-ID not found!");
        }
    }

}
