<?php

/*
 * This file is part of rap
 * Copyright (C) 2021 Istituto Nazionale di Astrofisica
 * SPDX-License-Identifier: GPL-3.0-or-later
 */

namespace RAP;

class OIDCDiscoveryGenerator {

    private $locator;

    public function __construct(Locator $locator) {
        $this->locator = $locator;
    }

    public function getConfiguration() {

        $config = $this->locator->config;

        $discoveryConfig = [];

        $host = filter_input(INPUT_SERVER, 'HTTP_HOST', FILTER_SANITIZE_STRING);
        $baseUrl = 'https://' . $host . $config->contextRoot;

        $discoveryConfig['issuer'] = $baseUrl;
        $discoveryConfig['authorization_endpoint'] = $baseUrl . '/auth/oauth2/authorize';
        $discoveryConfig['token_endpoint'] = $baseUrl . '/auth/oauth2/token';
        $discoveryConfig['jwks_uri'] = $baseUrl . '/auth/oidc/jwks';
        $discoveryConfig['scopes_supported'] = ['openid', 'email', 'profile'];
        $discoveryConfig['grant_types_supported'] = ['authorization_code', 'client_credentials', 'refresh_token', 'urn:ietf:params:oauth:grant-type:token-exchange'];
        $discoveryConfig['id_token_signing_alg_values_supported'] = ['RS256'];
        $discoveryConfig['claims_supported'] = ['sub', 'iss', 'iat', 'exp', 'name', 'aud', 'email', 'given_name', 'family_name', 'org'];

        return $discoveryConfig;
    }

}
