<?php

/*
 * This file is part of rap
 * Copyright (C) 2021 Istituto Nazionale di Astrofisica
 * SPDX-License-Identifier: GPL-3.0-or-later
 */

namespace RAP;

interface JWKSDAO {

    public function getRSAKeyPairs(): array;

    public function getRSAKeyPairById(string $id): ?RSAKeyPair;

    public function insertRSAKeyPair(RSAKeyPair $keyPair): RSAKeyPair;

    public function getNewestKeyPair(): ?RSAKeyPair;

    public function deleteKeyPair(string $id): void;
}
