<?php

/*
 * This file is part of rap
 * Copyright (C) 2021 Istituto Nazionale di Astrofisica
 * SPDX-License-Identifier: GPL-3.0-or-later
 */

use PHPUnit\Framework\TestCase;

class LocatorTest extends TestCase {

    public function testLocator() {

        define('ROOT', dirname(dirname(__FILE__)));

        $config = yaml_parse_file(ROOT . '/config-example.yaml');
        $config = json_decode(json_encode($config), FALSE);

        $locator = new \RAP\Locator($config);

        $this->assertNotNull($locator->getUserDAO());
        $this->assertNotNull($locator->getJWKSDAO());
        $this->assertNotNull($locator->getAccessTokenDAO());
        $this->assertNotNull($locator->getRefreshTokenDAO());
        $this->assertNotNull($locator->getUserHandler());
        $this->assertNotNull($locator->getOAuth2RequestHandler());
        $this->assertNotNull($locator->getTokenBuilder());
        $this->assertNotNull($locator->getTokenChecker());
        $this->assertNotNull($locator->getClientAuthChecker());
        $this->assertNotNull($locator->getSession());
        $this->assertNotNull($locator->getServiceLogger());
        $this->assertNotNull($locator->getAuditLogger());
        $this->assertNotNull($locator->getJWKSHandler());

        $this->assertNotNull($locator->getBrowserBasedOAuth2Clients());
        $this->assertNotNull($locator->getBrowserBasedOAuth2ClientById("gms", false));
        $this->assertNotNull($locator->getBrowserBasedOAuth2ClientByIdAndSecret("gms", "demo"));
        $this->assertNotNull($locator->getCliClientByIdAndSecret("gms_cli", "demo"));
    }

}
