<?php

/**
 * Functionalities for the admin panel.
 */
//

function checkUser() {

    session_start();
    global $locator;

    $session = $locator->getSession();
    if ($session->getUser() === null) {
        http_response_code(401);
        die("You must be registered to perform this action");
    }

    // TODO: check is admin
}

Flight::route('GET /admin', function() {
    checkUser();
    
    global $VERSION;
    Flight::render('admin/index.php', array('title' => 'Admin panel',
            'version' => $VERSION));
});

Flight::route('GET /admin/oauth2_clients', function() {

    checkUser();
    global $locator;

    $clients = $locator->getOAuth2ClientDAO()->getOAuth2Clients();

    Flight::json($clients);
});

Flight::route('POST /admin/oauth2_clients', function() {

    checkUser();
    global $locator;

    $client = $locator->getOAuth2ClientDAO()->createOAuth2Client(buildOAuth2ClientFromData());

    Flight::json($client);
});

Flight::route('PUT /admin/oauth2_clients', function() {

    checkUser();
    global $locator;

    $client = $locator->getOAuth2ClientDAO()->updateOAuth2Client(buildOAuth2ClientFromData());

    Flight::json($client);
});

Flight::route('DELETE /admin/oauth2_clients/@id', function($id) {

    checkUser();
    global $locator;

    $locator->getOAuth2ClientDAO()->deleteOAuth2Client($id);

    // Return no content
    Flight::halt(204);
});

function buildOAuth2ClientFromData() {

    $data = Flight::request()->data;
    $client = new \RAP\OAuth2Client();

    if (isset($data)) {
        if (isset($data['id'])) {
            $client->id = $data['id'];
        }
        $client->title = $data['title'];
        $client->icon = $data['icon'];
        $client->client = $data['client'];
        $client->secret = $data['secret'];
        $client->redirectUrl = $data['redirectUrl'];
        $client->scope = $data['scope'];
    }
    if (isset($data['authMethods'])) {
        foreach ($data['authMethods'] as $method) {
            array_push($client->authMethods, $method);
        }
    }

    return $client;
}
