<?php

/* ----------------------------------------------------------------------------
 *               INAF - National Institute for Astrophysics
 *               IRA  - Radioastronomical Institute - Bologna
 *               OATS - Astronomical Observatory - Trieste
 * ----------------------------------------------------------------------------
 *
 * Copyright (C) 2016 Istituto Nazionale di Astrofisica
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License Version 3 as published by the
 * Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 51
 * Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

namespace RAP;

interface UserDAO {

    /**
     * Create a new identity.
     * @param type $userId the user ID associated to that identity
     * @return type the new identity ID
     */
    function insertIdentity(Identity $identity, $userId);

    /**
     * Create a new user.
     * @return the new user ID.
     */
    function createUser();

    /**
     * @return RAP\User an user object, null if nothing was found.
     */
    function findUserById(string $userId): ?User;

    function setPrimaryIdentity($userId, $identityId);

    /**
     * Retrieve the user associated to a given identity using the typedId.
     * @param type $type Identity type (EDU_GAIN, X509, GOOGLE, ...)
     * @param type $typedId typed unique value used to search the identity in the database
     * @return RAP\User an user object, null if nothing was found.
     */
    function findUserByIdentity($type, $typedId);

    /**
     * Retrieve a set of users matching a given search text.
     * @param type $searchText name, surname or email
     * @return list of RAP\User objects
     */
    function searchUser($searchText);

    /**
     * Perform a join request.
     * @param type $userId1 the user that will receive all identities
     * @param type $userId2 the user that will lost the identities and will be
     * deleted from the database
     */
    function joinUsers($userId1, $userId2);
}
