<?php

/**
 * REST Web Service using http://flightphp.com/
 * This Web Service should be called only by authorized applications external to
 * RAP, so this directory should be password protected.
 * 
 * Apache configuration:
 * <Location "/rap-ia2/ws">
 *     AuthType basic
 *     AuthName RAP
 *     AuthUserFile rap-service-passwd
 *     Require valid-user
 * </Location>
 */
//
$WS_PREFIX = '/ws';

/**
 * Retrieve user information from login token.
 */
Flight::route('GET ' . $WS_PREFIX . '/user-info', function() {

    global $dao;

    $token = Flight::request()->query['token'];
    $userData = $dao->findLoginToken($token);

    if (is_null($userData)) {
        http_response_code(404);
        die("Token not found");
    }

    $dao->deleteLoginToken($token);

    header('Content-Type: text/plain');
    echo $userData;
});

/**
 * Retrieve user information from user ID.
 */
Flight::route('GET ' . $WS_PREFIX . '/user/@userId', function($userId) {

    global $locator;

    $locator->getOAuth2RequestHandler()->validateToken();

    $user = $locator->getUserDAO()->findUserById($userId);
    if ($user !== null) {
        Flight::json($user);
    } else {
        http_response_code(404);
        die("User not found");
    }
});

/**
 * Search users from search text (name, surname, email).
 */
Flight::route('GET ' . $WS_PREFIX . '/user', function() {

    global $locator;

    $locator->getOAuth2RequestHandler()->validateToken();

    $searchText = Flight::request()->query['search'];

    $users = $locator->getUserDAO()->searchUser($searchText);
    Flight::json($users);
});

/**
 * Create new user from identity data. Return the new user encoded in JSON.
 * This can be used to automatically import users without they explicitly
 * register (this is done for INAF eduGAIN users readling directly from LDAP).
 */
Flight::route('POST ' . $WS_PREFIX . '/user', function() {

    global $locator;

    $locator->getOAuth2RequestHandler()->validateToken();

    $postData = Flight::request()->data;

    $user = new RAP\User();

    $identity = new RAP\Identity($postData['type']);

    $identity->email = $postData['email'];
    $identity->typedId = $postData['typedId'];
    if (isset($postData['name'])) {
        $identity->name = $postData['name'];
    }
    if (isset($postData['surname'])) {
        $identity->surname = $postData['surname'];
    }
    if (isset($postData['institution'])) {
        $identity->institution = $postData['institution'];
    }
    if (isset($postData['eppn'])) {
        $identity->eppn = $postData['eppn'];
    }

    $user->addIdentity($identity);

    $locator->getUserHandler()->saveUser($user);

    Flight::json($user);
});

/**
 * Performs a join.
 */
Flight::route('POST ' . $WS_PREFIX . '/join', function() {

    global $locator;
    
    $locator->getOAuth2RequestHandler()->validateToken();
    
    $postData = Flight::request()->data;

    $userId1 = $postData['user1'];
    $userId2 = $postData['user2'];

    $user1 = $locator->getUserDAO()->findUserById($userId1);
    if ($user1 === null) {
        throw new BadRequestException("User " . $userId1 . " doesn't exists");
    }

    $user2 = $locator->getUserDAO()->findUserById($userId2);
    if ($user2 === null) {
        throw new BadRequestException("User " . $userId2 . " doesn't exists");
    }

    $locator->getUserHandler()->joinUsers($user1, $user2);

    // if the join has success, returns the remaining user id
    echo $userId1;
});
