<?php

/* ----------------------------------------------------------------------------
 *               INAF - National Institute for Astrophysics
 *               IRA  - Radioastronomical Institute - Bologna
 *               OATS - Astronomical Observatory - Trieste
 * ----------------------------------------------------------------------------
 *
 * Copyright (C) 2016 Istituto Nazionale di Astrofisica
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License Version 3 as published by the
 * Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 51
 * Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

include './include/init.php';

include './include/front-controller.php';
include './include/gui-backend.php';
include './include/rest-web-service.php';

// Error handling
Flight::map('error', function($ex) {
    if ($ex instanceof \RAP\BadRequestException) {
        http_response_code(400);
        echo "Bad request: " . $ex->message;
    } else if ($ex instanceof \RAP\UnauthorizedException) {
        http_response_code(401);
        echo "Unauthorized: " . $ex->message;
    } else if ($ex instanceof \Exception) {
        if ($ex->getMessage() !== null) {
            echo $ex->getMessage();
        } else {
            echo $ex->getTraceAsString();
        }
    } else {
        throw $ex;
    }
});

// Starting Flight framework
Flight::start();

