<?php

include '../../include/init.php';
startSession();
global $dao;

if (!isset($_REQUEST['client_id'])) {
    http_response_code(400);
    die("Client id is required");
}

if (!isset($_REQUEST['redirect_uri'])) {
    http_response_code(400);
    die("Redirect URI is required");
}

$clientId = $_REQUEST['client_id'];
$redirectUrl = $_REQUEST['redirect_uri'];

$client = $dao->getOAuth2ClientByClientId($clientId);
if ($client === null) {
    http_response_code(400);
    die("Invalid client id: " . $clientId);
}
if ($client->redirectUrl !== $redirectUrl) {
    http_response_code(400);
    die("Invalid client redirect URI: " . $redirectUrl);
}

$alg;
if (isset($_REQUEST['alg'])) {
    $alg = $_REQUEST['alg'];
} else {
    $alg = "RS256";
}

if (isset($_GET['code'])) {
    
} else {
    if (!isset($_REQUEST['state'])) {
        http_response_code(400);
        die("State is required");
    }
}

$oauth2Data = new \RAP\OAuth2Data();
$oauth2Data->clientName = $client->name;
$oauth2Data->clientIcon = $client->icon;
$oauth2Data->clientId = $client->id;
$oauth2Data->redirectUrl = $client->redirectUrl;

global $session;
$session->setOAuth2Data($oauth2Data);