<?php

/* ----------------------------------------------------------------------------
 *               INAF - National Institute for Astrophysics
 *               IRA  - Radioastronomical Institute - Bologna
 *               OATS - Astronomical Observatory - Trieste
 * ----------------------------------------------------------------------------
 *
 * Copyright (C) 2016 Istituto Nazionale di Astrofisica
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License Version 3 as published by the
 * Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 51
 * Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

/* Facebook callback page */

include '../../include/init.php';
startSession();

// Retrieve Facebook configuration
$Facebook = $AUTHENTICATION_METHODS['Facebook'];

$fb = new Facebook\Facebook([
    'app_id' => $Facebook['id'],
    'app_secret' => $Facebook['secret'],
    'default_graph_version' => $Facebook['version'],
        ]);

$helper = $fb->getRedirectLoginHelper();
if (isset($_GET['state'])) {
    $helper->getPersistentDataHandler()->set('state', $_GET['state']);
}

try {
    // obtaining current URL without query string
    $url = "https://$_SERVER[HTTP_HOST]" . strtok($_SERVER["REQUEST_URI"], '?');
    $accessToken = $helper->getAccessToken($url);
} catch (Facebook\Exceptions\FacebookResponseException $e) {
    // When Graph returns an error
    http_response_code(500);
    die('Graph returned an error: ' . $e->getMessage());
} catch (Facebook\Exceptions\FacebookSDKException $e) {
    // When validation fails or other local issues
    http_response_code(500);
    die('Facebook SDK returned an error: ' . $e->getMessage());
}
if (!isset($accessToken)) {
    if ($helper->getError()) {
        $errorMessage = "Error: " . $helper->getError() . "<br>";
        $errorMessage = $errorMessage . "Error Code: " . $helper->getErrorCode() . "<br>";
        $errorMessage = $errorMessage . "Error Reason: " . $helper->getErrorReason() . "<br>";
        $errorMessage = $errorMessage . "Error Description: " . $helper->getErrorDescription();
    } else {
        $errorMessage = "Bad request";
    }

    http_response_code(500);
    die($errorMessage);
}

try {
    // Returns a `Facebook\FacebookResponse` object
    $response = $fb->get('/me?fields=id,first_name,last_name,email', $accessToken);
} catch (Facebook\Exceptions\FacebookResponseException $e) {
    echo 'Graph returned an error: ' . $e->getMessage();
    exit;
} catch (Facebook\Exceptions\FacebookSDKException $e) {
    echo 'Facebook SDK returned an error: ' . $e->getMessage();
    exit;
}

$_SESSION['fb_access_token'] = (string) $accessToken;

$fbUser = $response->getGraphUser();

$typedId = $fbUser["id"];

// Search if the user is already registered into RAP using the Facebook ID.
$user = $userHandler->findUserByIdentity(RAP\Identity::FACEBOOK, $typedId);

if ($user === null) {
    // Create new user
    $user = new RAP\User();

    $identity = new RAP\Identity(RAP\Identity::FACEBOOK);
    $identity->email = $fbUser["email"];
    $identity->name = $fbUser["first_name"];
    $identity->surname = $fbUser["last_name"];
    $identity->typedId = $typedId;

    $user->addIdentity($identity);

    $session->userToLogin = $user;
    $session->save();
    header('Location: ' . $BASE_PATH . '/tou-check');
    die();
}

$auditLog->info("LOGIN,Facebook," . $user->id);
$callbackHandler->manageLoginRedirect($user, $session);
?>
