<?php

/* ----------------------------------------------------------------------------
 *               INAF - National Institute for Astrophysics
 *               IRA  - Radioastronomical Institute - Bologna
 *               OATS - Astronomical Observatory - Trieste
 * ----------------------------------------------------------------------------
 *
 * Copyright (C) 2016 Istituto Nazionale di Astrofisica
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License Version 3 as published by the
 * Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 51
 * Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

/* This page must be protected by client certificate authentication 
 * On Apache httpd:
 * SSLVerifyClient require
 * SSLVerifyDepth 10
 * SSLOptions +ExportCertData
 */

include '../../include/init.php';
startSession();

if (isset($_SERVER['SSL_CLIENT_VERIFY']) && isset($_SERVER['SSL_CLIENT_V_REMAIN']) &&
        $_SERVER['SSL_CLIENT_VERIFY'] === 'SUCCESS' && $_SERVER['SSL_CLIENT_V_REMAIN'] > 0) {

    $x509Data = RAP\X509Data::parse($_SERVER);

    $user = $userHandler->findUserByIdentity(RAP\Identity::X509, $x509Data->serialNumber);

    if ($user === null) {
        /**
         * We want to extract name and surname from the X.509 certificate, however X.509
         * puts name and surname together (inside the CN field).
         * If name and surname are single words it is possible to retrieve them splitting
         * on the space character, otherwise the user has to choose the correct combination.
         * In that case partial X.509 data is temporarily stored into the user session and
         * the page views/x509-name-surname.php is shown to the user before completing the
         * registration, in order to allow him/her selecting the correct name and surname.
         */
        if ($x509Data->name === null) {
            $session->x509DataToRegister = $x509Data;
            $session->save();
            header('Location: ' . $BASE_PATH . '/x509-name-surname');
        } else {
            $session->userToLogin = $x509Data->toUser();
            $session->save();
            header('Location: ' . $BASE_PATH . '/tou-check');
        }
        die();
    } else {
        $auditLog->info("LOGIN,X.509," . $user->id);
        $callbackHandler->manageLoginRedirect($user, $session);
    }
} else {
    http_response_code(500);
    die("Unable to verify client certificate");
}
