<?php

/* ----------------------------------------------------------------------------
 *               INAF - National Institute for Astrophysics
 *               IRA  - Radioastronomical Institute - Bologna
 *               OATS - Astronomical Observatory - Trieste
 * ----------------------------------------------------------------------------
 *
 * Copyright (C) 2016 Istituto Nazionale di Astrofisica
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License Version 3 as published by the
 * Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 51
 * Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

/**
 * Initialization file called by all the other pages.
 * Probably some global variables should be removed from here.
 */
define('ROOT', dirname(dirname(__FILE__)));

// Defining autoload for RAP classes
spl_autoload_register(function ($class_name) {
    $prefix = "RAP\\";
    $len = strlen($prefix);
    if (strncmp($prefix, $class_name, $len) === 0) {
        $classpath = ROOT . '/classes/' . substr($class_name, $len, strlen($class_name) - $len) . '.php';
        require $classpath;
    }
});

// Loading dependecy classes
include ROOT . '/vendor/autoload.php';
// Loading configuration
include ROOT . '/config.php';

// Setup logging
// Monolog require timezone to be set
date_default_timezone_set("Europe/Rome");
$log = new Monolog\Logger('mainLogger');
$log->pushHandler(new Monolog\Handler\StreamHandler($LOG_PATH, $LOG_LEVEL));
$auditLog = new Monolog\Logger('auditLogger');
$auditLog->pushHandler(new Monolog\Handler\StreamHandler($AUDIT_LOG_PATH, $LOG_LEVEL));

switch ($DATABASE['dbtype']) {
    case 'MySQL':
        $dao = new RAP\MySQLDAO($DATABASE);
        break;
    default:
        throw new Exception($DATABASE['dbtype'] . ' not supported yet');
}

$callbackHandler = new RAP\CallbackHandler($dao, $BASE_PATH, $CALLBACKS);
$userHandler = new RAP\UserHandler($dao, $GROUPER);
$mailSender = new RAP\MailSender($_SERVER['HTTP_HOST'], $BASE_PATH);

function startSession() {
    session_start();
    global $session, $dao;
    $session = RAP\SessionData::get($dao);
}
