<?php

namespace RAP;

class OAuth2RequestHandler {

    private $locator;

    public function __construct(\RAP\Locator $locator) {
        $this->locator = $locator;
    }

    public function handleAuthorizeRequest() {

        if (!isset($_REQUEST['client_id'])) {
            throw new \RAP\BadRequestException("Client id is required");
        }

        if (!isset($_REQUEST['redirect_uri'])) {
            throw new \RAP\BadRequestException("Redirect URI is required");
        }

        $clientId = $_REQUEST['client_id'];
        $redirectUrl = $_REQUEST['redirect_uri'];

        $client = $this->locator->getDAO()->getOAuth2ClientByClientId($clientId);
        if ($client === null) {
            throw new \RAP\BadRequestException("Invalid client id: " . $clientId);
        }
        if ($client->redirectUrl !== $redirectUrl) {
            throw new \RAP\BadRequestException("Invalid client redirect URI: " . $redirectUrl);
        }

        $alg;
        if (isset($_REQUEST['alg'])) {
            $alg = $_REQUEST['alg'];
        } else {
            $alg = "RS256";
        }

        if (isset($_GET['code'])) {
            
        } else {
            $this->executeStateFlow($client);
        }
    }

    private function executeStateFlow(OAuth2Client $client) {

        if (!isset($_REQUEST['state'])) {
            throw new \RAP\BadRequestException("State is required");
        }

        // Storing OAuth2 data in session
        $oauth2Data = new \RAP\OAuth2Data();
        $oauth2Data->clientId = $client->client;
        $oauth2Data->redirectUrl = $client->redirectUrl;
        $oauth2Data->state = $_REQUEST['state'];

        $session = $this->locator->getSession();
        $session->setOAuth2Data($oauth2Data);
    }

}
