<?php

/* ----------------------------------------------------------------------------
 *               INAF - National Institute for Astrophysics
 *               IRA  - Radioastronomical Institute - Bologna
 *               OATS - Astronomical Observatory - Trieste
 * ----------------------------------------------------------------------------
 *
 * Copyright (C) 2016 Istituto Nazionale di Astrofisica
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License Version 3 as published by the
 * Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 51
 * Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

namespace RAP;

/**
 * This class wraps various objects that need to be stored into the session in
 * order to provide an object oriented transparent session management.
 */
class SessionData {

    const KEY = "SessionData";

    public $user;
    public $userSearchResults;
    public $x509DataToRegister;
    // user which is going to perform the login (we need to store this in the
    // session because we need to check the Terms of Use user consensus, so we
    // redirect to another page after retrieving user data.
    public $userToLogin;
    public $oauth2Data;

    /**
     * Store the data into the $_SESSION PHP variable
     */
    public function save() {
        $_SESSION[SessionData::KEY] = $this;
    }

    /**
     * Update the user data model stored into the session after the primary
     * identity has changed, in order to avoid reading again the user data from
     * the database.
     * @param int $identityId
     */
    public function updatePrimaryIdentity($identityId) {
        foreach ($this->user->identities as $identity) {
            $identity->primary = ($identity->id === $identityId);
        }
    }

    public function setOAuth2Data(OAuth2Data $oauth2Data) {
        $this->oauth2Data = $oauth2Data;
        $this->save();
    }

    public function getOAuth2Data(): ?OAuth2Data {
        return $this->oauth2Data;
    }

}
