<?php

use PHPUnit\Framework\TestCase;

final class OAuth2RequestHandlerTest extends TestCase {

    public function testBadRequestExceptionIfMissingClientId(): void {

        $this->expectException(\RAP\BadRequestException::class);

        $locatorStub = $this->createMock(\RAP\Locator::class);

        $requestHandler = new \RAP\OAuth2RequestHandler($locatorStub);
        $requestHandler->handleAuthorizeRequest();
    }

    public function testInvalidClientRedirectURI(): void {

        $this->expectException(\RAP\BadRequestException::class);

        $_REQUEST['client_id'] = "client_id";
        $_REQUEST['redirect_uri'] = "redirect_uri";
        $_REQUEST['state'] = "state";

        $daoStub = $this->createMock(\RAP\DAO::class);
        $daoStub->method('getOAuth2ClientByClientId')->willReturn(new \RAP\OAuth2Client());

        $locatorStub = $this->createMock(\RAP\Locator::class);
        $locatorStub->method('getDAO')->willReturn($daoStub);

        $requestHandler = new \RAP\OAuth2RequestHandler($locatorStub);
        $requestHandler->handleAuthorizeRequest();
    }

    public function testExecuteOAuthStateFlow(): void {

        $_REQUEST['client_id'] = "client_id";
        $_REQUEST['redirect_uri'] = "redirect_uri";
        $_REQUEST['state'] = "state";

        $daoStub = $this->createMock(\RAP\DAO::class);
        $client = new \RAP\OAuth2Client();
        $client->redirectUrl = "redirect_uri";
        $daoStub->method('getOAuth2ClientByClientId')->willReturn($client);

        $sessionStub = $this->createMock(\RAP\SessionData::class);
        $sessionStub->method('setOAuth2Data'); //->willReturn(new \RAP\OAuth2Data());

        $locatorStub = $this->createMock(\RAP\Locator::class);
        $locatorStub->method('getDAO')->willReturn($daoStub);
        $locatorStub->method('getSession')->willReturn($sessionStub);

        $sessionStub->expects($this->once())
                ->method('setOAuth2Data')->with($this->anything());

        $requestHandler = new \RAP\OAuth2RequestHandler($locatorStub);
        $requestHandler->handleAuthorizeRequest();
    }

}
