<?php

namespace RAP;

interface AccessTokenDAO {

    /**
     * Store a new login token into the database.
     * @param type $token login token
     * @param type $userId
     */
    function createTokenData(AccessTokenData $tokenData): AccessTokenData;

    function retrieveTokenDataFromCode(string $codeHash): ?AccessTokenData;

    function deleteTokenData(string $codeHash): void;
}
