<?php

namespace RAP;

/**
 * Data related to access tokens stored into the database. This object is
 * retrieved from the database (using the code or the refresh token hashes) and
 * it is used to generate OAuth2 tokens.
 */
class AccessTokenData {

    private const TOKEN_LIFESPAN = 3600;

    public $id;
    public $codeHash;
    public $userId;
    public $creationTime;
    public $expirationTime;
    public $redirectUri;
    public $clientId;
    public $scope;

    public function __construct() {
        $this->creationTime = time();
        $this->expirationTime = $this->creationTime + AccessTokenData::TOKEN_LIFESPAN;
    }

    public function isExpired(): bool {
        return $this->expirationTime < time();
    }

}
