<?php

if($argc !== 3) {
    echo "Usage: php $argv[0] <user_id_1> <user_id_2>\n";
    echo "The second id will be deleted.\n";
    exit(1);
}

chdir(dirname(__FILE__));

include '../include/init.php';

$dao = $locator->getUserDAO();
$handler = $locator->getUserHandler();
$tokenBuilder = $locator->getTokenBuilder();

$user1 = $dao->findUserById((int) $argv[1]);
if($user1 === null) {
    echo "User $argv[1] not found";
    exit(1);
}

$user2 = $dao->findUserById((int) $argv[2]);
if($user2 === null) {
    echo "User $argv[2] not found";
    exit(1);
}

$handler->joinUsers($user1, $user2);

echo "OK\n";
