<?php

/*
 * This file is part of rap
 * Copyright (C) 2021 Istituto Nazionale di Astrofisica
 * SPDX-License-Identifier: GPL-3.0-or-later
 */

namespace RAP;

interface AccessTokenDAO {

    /**
     * Store a new login token into the database.
     * @param type $token login token
     * @param type $userId
     */
    function createTokenData(AccessTokenData $tokenData): AccessTokenData;

    function retrieveTokenDataFromCode(string $codeHash): ?AccessTokenData;

    function deleteTokenData(string $codeHash): void;
}
