<?php

namespace RAP;

/**
 * Model for the main RAP page (authentication method choice).
 */
class AuthPageModel {

    // boolean flags
    public $eduGAIN;
    public $orcid;
    public $x509;
    public $google;
    public $facebook;
    public $linkedIn;
    public $localIdP;
    //
    public $clientIcon;
    public $clientTitle;
    public $localIdPConfig;

    public function __construct(\RAP\Locator $locator, \RAP\RAPClient $client) {

        $config = $locator->config;

        $this->setupAuthenticationMethodFlags($config, $client);

        if ($this->localIdP) {
            $this->localIdPConfig = $config->authenticationMethods->LocalIdP;
        }

        if (isset($client->icon)) {
            $this->clientIcon = $client->getIconBasePath() . $client->icon;
        }
        $this->clientTitle = $client->title;
    }

    private function setupAuthenticationMethodFlags($config, $client) {

        $this->eduGAIN = isset($config->authenticationMethods->eduGAIN) &&
                in_array(AuthenticationMethods::EDU_GAIN, $client->authMethods);

        $this->orcid = isset($config->authenticationMethods->OrcID) &&
                in_array(AuthenticationMethods::ORCID, $client->authMethods);

        $this->x509 = isset($config->authenticationMethods->X509) &&
                in_array(AuthenticationMethods::X509, $client->authMethods);

        $this->google = isset($config->authenticationMethods->Google) &&
                in_array(AuthenticationMethods::GOOGLE, $client->authMethods);

        $this->facebook = isset($config->authenticationMethods->Facebook) &&
                in_array(AuthenticationMethods::FACEBOOK, $client->authMethods);

        $this->linkedIn = isset($config->authenticationMethods->LinkedIn) &&
                in_array(AuthenticationMethods::LINKED_IN, $client->authMethods);

        $this->localIdP = isset($config->authenticationMethods->LocalIdP) &&
                in_array(AuthenticationMethods::LOCAL_IDP, $client->authMethods);
    }

}
