<?php

/* ----------------------------------------------------------------------------
 *               INAF - National Institute for Astrophysics
 *               IRA  - Radioastronomical Institute - Bologna
 *               OATS - Astronomical Observatory - Trieste
 * ----------------------------------------------------------------------------
 *
 * Copyright (C) 2016 Istituto Nazionale di Astrofisica
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License Version 3 as published by the
 * Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 51
 * Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

namespace RAP;

class CallbackHandler {

    private $dao;
    private $basePath;
    private $callbacks;

    public function __construct(DAO $dao, $basePath, $callbacks) {
        $this->dao = $dao;
        $this->basePath = $basePath;
        $this->callbacks = $callbacks;
    }

    /**
     * returns null if the callback URL is not listed in configuration file.
     */
    public function getCallbackTitle($callbackURL) {

        if ($callbackURL === null) {
            return "Account Management";
        }

        foreach ($this->callbacks as $callback) {
            if ($callback['url'] === $callbackURL) {
                return $callback['title'];
            }
        }

        throw new \Exception("Unauthorized callback URL");
    }

    public function manageLoginRedirect($user, SessionData $session) {

        if ($session->getCallbackURL() !== null) {
            // External login using token
            header('Location: ' . $this->getLoginWithTokenURL($user->id, $session->getCallbackURL()));
            die();
        } else {
            // Login in session
            $session->user = $user;
            $session->save();
            // Return to index
            header('Location: ' . $this->basePath);
            die();
        }
    }

    public function getLoginWithTokenURL($userId, $callbackURL) {
        $token = Util::createNewToken();
        $this->dao->createLoginToken($token, $userId);
        return $callbackURL . '?token=' . $token;
    }

}
